 ; Ŀ
 ;   Vino - replace one att. in several blocks with sequential numbers.    
 ;   Copyright 2003 by Rocket Software Ltd.                                
 ;   Is any of this true?                                                  
 ; 
 (DEFUN C:VINO (/ blocked defau enok enox enoo verti batter esav *error*
                  snapp order main entt enam tagg vall sublst attnam pos)

 ; Ŀ
 ;   Blocked: subroutine to edit the terminal strip numbers.               
 ;   Order is the list of enames in order by position.                     
 ;   (Actually that part makes no sense in the current context...)         
 ; 
 (DEFUN BLOCKED (order attnam stanum incrmt pref suff / ppref pos enam esava
                                                                   ent vis)
  (setq pos 0)
  (while (setq esava (setq enam (nth pos order)))
         (setq pos (1+ pos))
         (setq ent (entget enam))
         (while (/= "SEQEND" (cdr (assoc 0 ent)))
                (if (and (= (cdr (assoc 0 ent)) "ATTRIB")
                         (or (= (cdr (assoc 2 ent)) attnam) ; if att to change
                             (= attnam " ")))               ; or change all
                    (progn
 ; Ŀ
 ;   Make the new number string.                                           
 ; 
                         (setq strnum (strcat pref (enoo stanum 2) suff))
                         (entmod (subst (cons 1 strnum) (assoc 1 ent) ent))
                         (setq stanum (+ incrmt stanum))))
                (setq ent (entget (setq enam (entnext enam)))))
         (entupd esava))
 stanum)
 ; Ŀ
 ;   Blocked end.                                                          
 ; 

 ; Ŀ
 ;   Subroutine Defau - return all tiles to their default values.          
 ; 
 (DEFUN DEFAU ()
  (set_tile "start" "1")
  (set_tile "increment" "1")
  (set_tile "prefix" "")
  (set_tile "suffix" ""))
 ; Ŀ
 ;   Defau end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Enok: see whether the various edit box values are ok.      
 ;   If so and the callback was the result of an <Enter> (Reason = 1),     
 ;   then return a list of the edit box values.                            
 ;   The Ok button returns two numbers: a 2 immediately followed by a 1.   
 ;   They are interpreted sequentially - the 2 doesn't block the 1.        
 ;                                                                         
 ;   Conditions for accepting the dialog box contents:                     
 ;   1. The Start box contains a number, and                               
 ;   2. the Increment box contains a number.                               
 ;   Anything is acceptable in the prefix and suffix boxes.                
 ; 
 (DEFUN ENOK (reason / start incr typs typi prefa suffa retlst)
  (setq start (get_tile "start"))
  (setq incr (get_tile "increment"))
  (setq typs (type (read start)))
  (setq typi (type (read incr)))
  (setq prefa (get_tile "prefix"))
  (setq suffa (get_tile "suffix"))
  (cond ((not (or (= typs 'INT) (= typs 'REAL)))
         (set_tile "enotext" "Start value is not a number."))
        ((not (or (= typi 'INT) (= typi 'REAL)))
         (set_tile "vinotext" "Increment value is not a number."))
        (t
         (set_tile "vinotext" "")
         (if (= reason 1)
             (progn
                  (setq retlst (list start incr prefa suffa))
                  (done_dialog)))))
 retlst)
 ; Ŀ
 ;   Enok end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Enox - call a dialog box to get various values.            
 ; 
 (DEFUN ENOX (start incra prefa suffa / enolst)
  (setq dcl_id (load_dialog "vino.dcl"))
  (new_dialog "vino" dcl_id)            ; must come before data for box
  (action_tile "edit_ok" "(setq enolst (enok 1))")
  (action_tile "defaults" "(defau)")
  (action_tile "start" "(setq enolst (enok $reason))")
  (action_tile "increment" "(setq enolst (enok $reason))")
  (action_tile "prefix" "(setq enolst (enok $reason))")
  (action_tile "suffix" "(setq enolst (enok $reason))")
  (set_tile "start" start)
  (set_tile "increment" incra)
  (set_tile "prefix" prefa)
  (set_tile "suffix" suffa)
  (start_dialog)
  (unload_dialog dcl_id)
 enolst)
 ; Ŀ
 ;   Enox end.                                                             
 ; 

 ; Ŀ
 ;   Enoo - trailing zero remover.                                         
 ;   Arguments: Num, a number.                                             
 ;              Placo, the number of decimal places to look for.           
 ;   Returns a string without zeros after the decimal point.               
 ; 
 (DEFUN ENOO (num placo / strnum strnump pnum lasdig)
  (if (equal (read (rtos num 2 placo)) 0) "0"
      (progn
           (setq strnump (setq strnum (rtos num 2 placo)))
           (setq pnum strnump)        ; for while initialization
           (while (= strnump pnum)
                  (setq pnum (substr strnump 1 (1- (strlen strnump))))
                  (setq lasdig (substr strnump (strlen strnump)))
                  (if (equal lasdig "0") (setq strnump pnum)))
           (if (equal lasdig ".") pnum strnum))))
 ; Ŀ
 ;   Enoo end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Verti: returns a list of block names in order by position. 
 ; 
 (DEFUN VERTI (/ xposnam yposnam maxi mini ss numm ent entt xpos ypos xx yy pn
                 maxx minx maxy miny xdif ydif poslst posnam direct pos llast
                 order)
  (setq xposnam ())                      ; initialize (xpos & name list) list
  (setq yposnam ())                      ; initialize (ypos & name list) list
  (setq maxi (list 'max))                ; initialize max & min command lists
  (setq mini (list 'min))                ; (a lisp command is also a list)
 ; Ŀ
 ;   Get an ss and remove non-insert entities.                             
 ; 
  (write-line "Select blocks to edit: ")
  (setq ss (ssget))                      ; select some entities
  (setq numm 0)                          ; start at beginning of selection set
  (while (setq ent (ssname ss numm))     ; get the first entity name
         (setq entt (entget ent))        ; get the whole thing
         (if (= (cdr (assoc 0 entt)) "INSERT")    ; if it was a block
             (setq numm (1+ numm))       ; go to next entity
             (ssdel ent ss)))            ; otherwise remove it from the ss
 ; Ŀ
 ;   Now see if the entities are arranged horizontally or vertically.      
 ; 
  (setq numm 0)                             ; start at the ss beginning again
  (while (setq ent (ssname ss numm))
         (setq entt (entget ent))
         (setq xpos (cadr (assoc 10 entt)))
         (setq ypos (caddr (assoc 10 entt)))
         (setq xx (append xx (list xpos)))  ; add x insert to list
         (setq yy (append yy (list ypos)))  ; and y to y list
 ; Ŀ
 ;   Also make the position and name list.  Have to make one for the X     
 ;   values and one for the Ys and use the appropriate one later.          
 ; 
         (setq pn (cons xpos ent))
         (setq xposnam (append xposnam (list pn)))
         (setq pn (cons ypos ent))
         (setq yposnam (append yposnam (list pn)))
         (setq numm (1+ numm)))             ; next entity
 ; Ŀ
 ;   Now make the four command lists and evaluate them.  The result will   
 ;   be the max and min values for the X and Y lists.                      
 ; 
  (setq maxx (eval (append maxi xx)))
  (setq minx (eval (append mini xx)))
  (setq maxy (eval (append maxi yy)))
  (setq miny (eval (append mini yy)))
  (setq xdif (- maxx minx))
  (setq ydif (- maxy miny))
 ; Ŀ
 ;   Set vert to T if vertical, nil if horizontal.  If not sure, assume    
 ;   vertical... I think... Could set strip to Quit and thus do so.        
 ; 
  (cond ((> xdif ydif)                     ; if (Xmax - Xmin) > (Ymax - Ymin)
          (setq poslst xx)                 ; positions from X coord list
          (setq posnam xposnam)            ; position & ename list with X coord
          (setq direct mini))              ; edit from smallest to largest X
        ((< xdif ydif)
          (setq poslst yy)
          (setq posnam yposnam)
          (setq direct maxi))
        (T                                 ; if not sure then call it vertical
          (setq poslst yy)
          (setq posnam yposnam)
          (setq direct maxi)))
 ; Ŀ
 ;   Now make the list of enames in order by increasing X or decreasing Y  
 ;   coordinate depending on whether the array is horizontal or vertical.  
 ;                                                                         
 ;   Already Have Posnam: a list of (list position ename).                 
 ;   Using the original list of either x or y positions, get the first or  
 ;   last as appropriate, extract the ename from Posnam using              
 ;   (cdr (assoc (largest Y or smallest X) posnam))                        
 ;   and append the ename to the end of the enames in order list: Order.   
 ;   Then remove that position from the position list.                     
 ;                                                                         
 ; 
  (while (> (length poslst) 0)
 ; Ŀ
 ;   Get the largest Y or smallest X value in the position list.           
 ; 
         (setq maxx (eval (append direct poslst)))
 ; Ŀ
 ;   Having found Maxx, want to remove that value from poslst.             
 ;   Get the list from Maxx on, and the position of Maxx within the list.  
 ; 
         (setq pos (- (length poslst)
                      (length (setq llast (member maxx poslst)))))
 ; Ŀ
 ;   Get the list after maxx.                                              
 ; 
         (setq llast (cdr llast))
 ; Ŀ
 ;   And add the list members before maxx.                                 
 ;   One could use (cdr (member (reverse poslist))) but if there were two  
 ;   values the same in the list this would result in a longer rather      
 ;   than a shorter poslist.                                               
 ; 
         (setq pos (1- pos))     ; subtract one: nth is zero based
         (while (>= pos 0)
                (setq llast (append (list (nth pos poslst)) llast))
                (setq pos (1- pos)))
         (setq poslst llast)      ; poslst becomes llast
 ; Ŀ
 ;   Now get the matching ename from posnam and add it to the end of the   
 ;   order list.                                                           
 ; 
         (setq order (append order (list (cdr (assoc maxx posnam)))))
 ; Ŀ
 ;   If there are two entities with the same position then assoc will      
 ;   always return the first one.  Must delete the first one each time -   
 ;   subst (nil) for it.                                                   
 ; 
         (setq posnam (subst (list nil) (assoc maxx posnam) posnam)))
 order)
 ; Ŀ
 ;   Verti end.                                                            
 ; 

 ; Ŀ
 ;   Batter - replacement error handler.  Restores original values to      
 ;   attributes if something goes wrong.                                   
 ; 
 (DEFUN BATTER (shk / pos entt enam sublst vall)
  (setvar "snapmode" snapp)
  (if (and esav main)
      (progn
           (setq pos 0)
           (setq entt (entget (setq enam esav)))
           (while (/= (cdr (assoc 0 entt)) "SEQEND")
                  (setq enam (entnext enam))
                  (setq entt (entget enam))
                  (setq sublst (nth pos main))
                  (setq vall (cadr sublst))
                  (setq pos (1+ pos))
                  (entmod (subst (cons 1 vall) (assoc 1 entt) entt)))
           (entupd esav)))
  (setq *error* esav)
 (princ))
 ; Ŀ
 ;   Batter end.                                                           
 ; 

 ; Ŀ
 ;   Vino. (Defun header is at top of file for subroutine locality.        
 ; 
  (command "undo" "be")
  (setq esav *error*)                    ; save the previous error handler
  (setq *error* batter)                  ; and install the new one
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq order (verti))   ; verti returns a list of inserts ordered by position
  (setq main ())                         ; list of attribute values to restore
 ; Ŀ
 ;   Use the first insert in the ordered list Order to display the         
 ;   attribute tag names and ask which one to edit.                        
 ; 
  (while (and (car order)
              (null (assoc 66 (entget (car order)))))
         (setq order (cdr order)))
  (if (setq enam (car order))
      (setq entt (entget (setq esav enam))))
 ; Ŀ
 ;   Step through the insert, substituting the tag names for attribute     
 ;   values, save the original values so they can be restored.             
 ; 
  (if (and (= (cdr (assoc 0 entt)) "INSERT")
           (assoc 66 entt))
      (progn
           (while (/= (cdr (assoc 0 entt)) "SEQEND")
                  (setq enam (entnext enam))
                  (setq entt (entget enam))
                  (setq tagg (cdr (assoc 2 entt)))
                  (setq vall (cdr (assoc 1 entt)))
                  (if (and tagg vall)
                      (progn
                           (setq sublst (list tagg vall))
                           (setq main (append main (list sublst)))
                           (entmod (subst (cons 1 tagg)
                                          (cons 1 vall) entt)))))
           (entupd esav)
 ; Ŀ
 ;   Prompt for an attribute to edit, get the tag.                         
 ; 
           (if (setq attnam (nentsel
                            "\nAttribute to edit or <Return> for all: "))
               (progn
                    (setq attnam (cdr (assoc 2 (entget (car attnam)))))
                    (princ attnam))
               (progn
                    (setq attnam " ")
                    (write-line "Changing all attributes.")))
 ; Ŀ
 ;   Restore the original values to the block from the list Main.          
 ; 
           (setq entt (entget (setq enam esav)))
           (setq pos 0)
           (while (/= (cdr (assoc 0 entt)) "SEQEND")
                  (setq enam (entnext enam))
                  (setq entt (entget enam))
                  (setq sublst (nth pos main))
                  (setq vall (cadr sublst))
                  (setq pos (1+ pos))
                  (entmod (subst (cons 1 vall) (assoc 1 entt) entt)))
           (entupd esav)
 ; Ŀ
 ;   Make default data values if there are no global ones.                 
 ; 
           (if (/= (type stanum) 'REAL) (setq stanum 1.0))
           (if (/= (type incrmt) 'REAL) (setq incrmt 1.0))
           (if (/= (type pref) 'STR) (setq pref ""))
           (if (/= (type suff) 'STR) (setq suff ""))
 ; Ŀ
 ;   Call the dialog box to get new values.                                
 ; 
           (if (setq enolst (enox (rtos stanum 2) (rtos incrmt 2) pref suff))
               (progn
                    (setq stanum (float (read (nth 0 enolst))))
                    (setq incrmt (read (nth 1 enolst)))
                    (setq pref (nth 2 enolst))
                    (setq suff (nth 3 enolst))
 ; Ŀ
 ;   Now call blocked to edit the insertions.                              
 ; 
                    (if attnam 
                       (setq stanum (blocked order attnam stanum incrmt pref
                                             suff))
                       (prompt "*** No blocks with attributes. ***"))))))
  (setq *error* esav)
  (setvar "snapmode" snapp)
  (command "undo" "end")
 (princ))